import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public class Node extends DrawObject
{
	// DrawObject abilities:
	@Override
	public boolean CanBeDeletedByUser()
	{
		return true;
	};

	@Override
	public boolean CanBeExcitedByUser()
	{
		return true;
	};

	@Override
	public boolean CanBeMovedByUser()
	{
		return true;
	};

	@Override
	public boolean CanBeSelectedByUser()
	{
		return true;
	}
	// end of DrawObject abilities

	public Node(Point Pos)
	{
		SetPos(Pos);
		SetSize(new Point(10, 10));
		InitializeExcitement(ExcitementOnceMilliseconds);
	};

	@Override
	public void Draw(Graphics g)
	{
		if (!(IsWithinWindowBounds(this, 0)))
			return;

		// background
		if (IsHighlighted || IsPartOfMultiSelection)
			SetColor(g, Color.GREEN);
		else
			SetColor(g, Color.LIGHT_GRAY);
		FillRect(g, Pos.x, Pos.y, Size.x, Size.y);

		// frame
		if (IsCommentField)
			SetColor(g, GetExcitementColor(Color.BLUE));
		else
			SetColor(g, GetExcitementColor(Color.RED));
		DrawRect(g, Pos.x, Pos.y, Size.x, Size.y);
	}

	@Override
	protected void SetPos(Point PosNew)
	{
		Pos = AlignOnGrid(PosNew);
	}

	@Override
	protected void SetSize(Point SizeNew)
	{
		if (SizeNew.x < 1000 && SizeNew.y < 1000)
			Size = SizeNew;
		else
			System.out.println("error in Node.SetSize(): passed value not useful!");
	}
}
